package gov.va.med.term.vhat.data.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Version
{
	private boolean append;
	private String name;
	private Date effectiveDate;
	private Date releaseDate;
	private String source;
	private String description;
	private List<ConceptImportDTO> concepts = new ArrayList<>();
	private List<MapSetImportDTO> mapsets = new ArrayList<>();

	public Version(String name, String source, String description, Date effectiveDate, Date releaseDate, boolean append)
	{
		this.name = name;
		this.effectiveDate = effectiveDate;
		this.description = description;
		this.source = source;
		this.releaseDate = releaseDate;
		this.append = append;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @return
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * @return
	 */
	public Date getEffectiveDate()
	{
		return effectiveDate;
	}

	/**
	 * @return the releaseDate
	 */
	public Date getReleaseDate()
	{
		return releaseDate;
	}

	/**
	 * @return the source
	 */
	public String getSource()
	{
		return source;
	}

	public boolean getAppend()
	{
		return append;
	}

	public List<ConceptImportDTO> getConcepts()
	{
		return concepts;
	}

	public List<MapSetImportDTO> getMapsets()
	{
		return mapsets;
	}
}
